#|___________________________________________________________________ 
 | 
 |        ViSta - The Visual Statistics System
 |        Copyright (c) 1991-2001 by Forrest W. Young
 |        www.visualstats.org  forrest@visualstats.org
 |
 |        INIT.LSP (must be located in ViSta home directory)
 |
 |        This file is loaded when there is no xlisp.wks file
 |        Statinit.lsp is loaded when there is a xlisp.wks file.
 |
 |        There are two legitimate situations with no xlisp.wks file 
 |        1] During Installation
 |           This is the situation when vista-installer.wks exists.
 |           The code in the present file manages this installation.
 |        2] During Development
 |           There are no vista-installer.wks nor xlixp.wks files.
 |           In this case maketime\maker is loaded to re-create the 
 |           standard vista runtime xlisp.wks
 |
 |        This file creates the vista-installer.wks file and
 |        uses init-functions.lsp to manage the installation
 |_________________________________________________________________ 
 |# 






; 1 - initialize xlispstat
(setf *edit-lisp-files* nil) ;place in load lsp files mode
(setf *load-editeval* nil)

;(showmainwindow)
;(mainwindow 0 0 (+ 8 (first (screen-size))) (+ 132 (second (screen-size))) )
;(when (or (not (boundp '*run-number*)) (< *run-number* 0))
;      (listener (floor (/ (- (first (screen-size)) 600) 2)) 24
;                600 (floor (/ (second (screen-size)) 3))))

(format t "~%; HOMEING ~a~%" (get-working-directory))
(setf *startup-dir*  (get-working-directory))
(setf *startup-path*  (format nil "~a\\" (get-working-directory)))
(format t "; loaded  ~a\\init.lsp~%" *startup-dir*)
(format t "; *startup-dir*  ~a~%" *startup-dir*)
(setf *default-path* (format nil "~a\\" *startup-dir*))
(setf xlisp::*default-path* *default-path*)
(format t "; *default-path* ~a~%" *default-path*)
(setf *home-path* *default-path*)
(format t "; *home*         ~a~%" *home-path*)
(setf *ini-file* (format nil "~a~a" *default-path* "wxls32.ini"))
(format t "; *ini-file*     ~a~%" *ini-file*)
(setf *lispsrc-dir* (format nil "~a~a" *default-path* "lspsrc"))
(format t "; *lispsrc-dir*  ~a~%" *lispsrc-dir*)

(format t "~%; LOADING XLISP-STAT LispCode~%")

(set-working-directory *lispsrc-dir*)
(format t "; loading ~a\\init.lsp~%" *lispsrc-dir*)
(load "init")
(set-working-directory "..")
(format t "~%; BOOTING ViSta~%")
;(pause 30)
(load "init-functions")
(setf *separator* #+macintosh ":" #+msdos "\\" #+X11 "/") 
(setf *default-path* (get-working-directory))
(format t "; pathing *default-path* ~a~%" *default-path*)
;(set-working-directory "lspsrc")
;(load (concatenate 'string *default-path* *separator* "lspsrc" *separator* "init"))
;(set-working-directory "..")

(format t "~%; PATHING *load-pathname-defaults* ~a~%" *load-pathname-defaults*)
;(pause 30)
(setf *load-pathname-defaults*
      (combine *load-pathname-defaults*
               (concatenate 'string *default-path* *separator* "plugins")))
(format t "; pathing *load-pathname-defaults*~%")
(mapcar #'(lambda (string)
           (format t "; ... ~a~%" string))
       *load-pathname-defaults*)
(load (make-pathname :directory (list :relative *default-path*)
                     :name "init-functions"))
(setf *help-file-name* (strcat  *default-path* "\\xlisp.hlp"))
(setf *help-stream* (open *help-file-name* :if-does-not-exist nil))
(setf *help-loaded* t)


(pushnew :vista *features*)

(cond 
  ((probe-file "vista-installer.wks");(probe-for-vista-installer)
   (format t "~%; INSTALL ViSta from ViSta-Installer.wks~%")
  ; (Please-wait (format nil "CREATING LISPBOSS WORKSPACE:  Please Wait."))
  ; (Please-wait (format nil "CREATING LISPBOSS WORKSPACE:  Please Wait."))
  ; (pause 60)


; 5 Initialize filetypes

  ; (set-filetypes)
   (set-working-directory "lispboss")
;(pleAse-wait (format nil "SET WORKING DIRECTORY"))
;(PAUSE 120)

   (defun make-new-lispboss-xlisp.wks ()
     (let* ((file-length-b4 0)
            (file-length-now 0)
            (knt 0)
            (loops 0))
       (when (probe-file "xlisp.wks") (delete-file "xlisp.wks"))
       (system "lispboss.exe")
       (loop 
         (setf loops (1+ loops))
         (when (probe-file "xlisp.wks") 
               (Please-wait (format nil "Localizing File Manager - Please Wait"
                              :title "PLEASE WAIT"))
               (Please-wait (format nil "Localizing File Manager - Please Wait"
                              :title "PLEASE WAIT"))
               (with-open-file (f "xlisp.wks")
                  ; (pause 60)
                  ; (Please-wait (format nil 
                  ;   "Localizing LispBoss - Please Wait ~a ~a" knt loops))
                  ; (Please-wait (format nil 
                  ;   "Localizing LispBoss - Please Wait ~a ~a" knt loops))
                   (setf file-length-now (file-length f))
                   (if (and (> file-length-now 0)
                            (= file-length-now file-length-b4))
                       (return)
                       (setf file-length-b4 file-length-now))))))
     (pause 60))

   (make-new-lispboss-xlisp.wks)
   (set-working-directory "..")
  ; (wait-for-file-update "lispboss\lisp.wks")	
  ; (Please-wait (format nil "Localizing ViSta    - Please Wait."))
  ; (Please-wait (format nil "Localizing ViSta    - Please Wait."))
  ; (PAUSE 60)

; 2 - rename vista-installer.wks
   
   (rename-file "vista-installer.wks" "xlisp.wks")
   
; 3 - Run vista.exe using renamed vista-installer.wks.
;     This installs vista and creates a new localized xlisp.wks.
   
   (system "vista.exe")
   
; 4 - Wait for new localized xlisp.wks
   
   (wait-for-file-update "xlisp.wks")
   

; 6 - run localized vista using localized xlisp.wks
   
   (system "vista.exe")
   (exit)
   )
  (t 
   (setf *dribble-on* t)
   (setf *jump-start* t)
   (setf *make-log* t)
   (unless (load (make-pathname 
                  :directory (list :relative *default-path* "maketime")
                  :name "maker")
                 :if-does-not-exist nil)
           (format nil "~%; ViSta maketime\maker file does not exist")
           )))

